package kochModel;

import fp.*;
import java.awt.*;
import lrs.*;

import kochModel.*;
import java.awt.geom.Point2D.Double;
/**
 * This class represents a Koch curve between two points.   The Koch curve may be either a straight line or
 * a collection of line segments.
 */
public class Koch implements IFoldHost<Koch> {
  private Double a;
  private Double b;
  private AKochState aKochState = new BaseState();
  /**
   * Constructor for a base case Koch curve.
   * @param a The beginning point.
   * @param b The ending point.
   */
  public Koch(Double a, Double b) {
    this.a = a;
    this.b = b;
  }
  
  /**
   * Constructor for the non-base case Koch curve.
   * @param kochList The list of Koch curves needed by the  InductState
   */
  public Koch(Double a, Double b, LRStruct<Koch> kochList) {
    this(a, b);
    aKochState = new InductState(kochList);
  }
  

  
  /**
   * Accessor method for the first point of the curve.
   * @return
   */
  public Double getA() {
    return(a);
  }
  
  /**
   * Accessor method for the last point of the curve.
   * @return
    */
  public Double getB() {
    return(b);
  }
  
  /**
   * Sets the state of the Koch curve to the supplied state.   Used internally only.
   *
   */
  void setKochState(AKochState aKochState) {
    this.aKochState = aKochState;
  }
  
  AKochState getKochState() {
    return aKochState;
  }
  
  public <R,P> R execute(IKochVisitor<R,P> algo, P... param) {
    return aKochState.execute(this, algo, param);
  }
  
  
  public <R,P> R fold(IFoldAlgo<Koch,R,P> algo, R base, P... param) {
    return aKochState.fold(this,algo, base, param);
  }
  
  /**
   * sets A & B points and internal state to be the same as other Koch's 
   */
  public void shareState(Koch other) {
    a = other.getA();
    b = other.getB();
    setKochState(other.getKochState());
  }
}

